<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Register - SIFORNI</title>
  <!-- Recommended: use Bootstrap via CDN in production -->
  <link rel="stylesheet" href="/assets/css/bootstrap.min.css">
</head>
<body class="bg-light">
<div class="container mt-5">
  <div class="row justify-content-center">
    <div class="col-md-6">
      <div class="card">
        <div class="card-body">
          <h4 class="card-title">Daftar Alumni</h4>

          <?php if(session()->getFlashdata('errors')): ?>
            <div class="alert alert-danger">
              <ul>
              <?php foreach(session()->getFlashdata('errors') as $e): ?>
                <li><?= esc($e) ?></li>
              <?php endforeach ?>
              </ul>
            </div>
          <?php endif ?>

          <form action="/register" method="post">
            <?= csrf_field() ?>
            <div class="mb-3">
              <label class="form-label">Nama</label>
              <input type="text" name="name" class="form-control" value="<?= old('name') ?>">
            </div>
            <div class="mb-3">
              <label class="form-label">Email</label>
              <input type="email" name="email" class="form-control" value="<?= old('email') ?>">
            </div>
            <div class="mb-3">
              <label class="form-label">Password</label>
              <input type="password" name="password" class="form-control">
            </div>
            <div class="mb-3">
              <label class="form-label">Konfirmasi Password</label>
              <input type="password" name="password_confirm" class="form-control">
            </div>
            <button class="btn btn-primary">Daftar</button>
            <a href="/login" class="btn btn-link">Sudah punya akun? Login</a>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
</body>
</html>
