<?php namespace App\\Controllers;

use App\\Controllers\\BaseController;
use App\\Models\\UserModel;

class Auth extends BaseController
{
    protected $userModel;
    protected $session;

    public function __construct()
    {
        $this->userModel = new UserModel();
        $this->session = session();
    }

    public function register()
    {
        return view('auth/register');
    }

    public function create()
    {
        $rules = [
            'name' => 'required|min_length[3]|max_length[150]',
            'email' => 'required|valid_email|is_unique[users.email]',
            'password' => 'required|min_length[6]',
            'password_confirm' => 'matches[password]'
        ];

        if (! $this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $data = [
            'name' => $this->request->getPost('name'),
            'email' => $this->request->getPost('email'),
            'password_hash' => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),
            'role' => 'alumni'
        ];

        $this->userModel->insert($data);

        $this->session->setFlashdata('success', 'Registrasi sukses. Silakan login.');
        return redirect()->to('/login');
    }

    public function login()
    {
        return view('auth/login');
    }

    public function attempt()
    {
        $email = $this->request->getPost('email');
        $password = $this->request->getPost('password');

        $user = $this->userModel->where('email', $email)->first();
        if (! $user) {
            return redirect()->back()->with('error', 'Email tidak ditemukan')->withInput();
        }

        if (! password_verify($password, $user['password_hash'])) {
            return redirect()->back()->with('error', 'Password salah')->withInput();
        }

        // optional: check verification
        // if (! $user['is_verified']) { ... }

        $this->session->set([
            'user_id' => $user['id'],
            'user_email' => $user['email'],
            'user_name' => $user['name'],
            'user_role' => $user['role'],
            'isLoggedIn' => true
        ]);

        return redirect()->to('/dashboard');
    }

    public function logout()
    {
        $this->session->destroy();
        return redirect()->to('/login');
    }
}
