<?php
namespace App\Models;
class User extends Model {
    public function findByEmail($email) {
        $stmt = $this->db->prepare('SELECT * FROM users WHERE email = :email');
        $stmt->execute([':email'=>$email]);
        return $stmt->fetch(\PDO::FETCH_ASSOC);
    }
    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO users (email,password,role,name,email_verified,created_at) VALUES (:email,:password,:role,:name,0,NOW())');
        $stmt->execute([
            ':email'=>$data['email'],
            ':password'=>$data['password'],
            ':role'=>$data['role'],
            ':name'=>$data['name']
        ]);
        return $this->db->lastInsertId();
    }
}
